CREATE or REPLACE PROCEDURE proc_create_station_report (v_StateName CHAR) IS

v_CountyName state_county.county_name%type;
v_StateCode station2.state_code%type;

CURSOR c_Counties IS
	SELECT unique(county_name)
		FROM station2
		WHERE state_name = v_StateName;

BEGIN

OPEN c_Counties;

	SELECT unique(state_code) INTO v_StateCode
	FROM station2
	WHERE state_name = v_StateName;

LOOP
	FETCH c_Counties INTO v_CountyName;
	Exit WHEN c_Counties%NOTFOUND;
	dbms_output.enable(10000000);
	dbms_output.put_line('SPOOL H:/joe/'||TRANSLATE(TRIM(v_StateName), ' ', '_')||'/'||TRANSLATE(TRIM(v_StateCode), ' ', '_')||'_'||TRANSLATE(TRIM(v_CountyName), ' ', '_')||'_sta.txt');
	dbms_output.put_line('SELECT fk_agency_code, primary_station_id,');
	dbms_output.put_line('rtrim(location_name)||'' / ''||rtrim(location_name_2)||'' / ''||rtrim(location_name_3) AS "Station Name", agency_name,');
	dbms_output.put_line('state_name, county_name, latitude, CASE WHEN longitude IS NULL THEN NULL ELSE ''-''||longitude END AS "long", fips_hydrologic_unit_code, rchmile_segment, miles_up_reach, rchonoff, rchname,');
	dbms_output.put_line('station_alias, lgcy_storet_station_type_code, station_depth, station_depth_units, surface_water_indicator, ground_water_indicator, description');
	dbms_output.put_line('FROM station2');
	dbms_output.put_line('WHERE county_name = '''||trim(v_CountyName)||'''');
	dbms_output.put_line('and state_name = '''||trim(v_StateName)||'''');
	dbms_output.put_line('ORDER BY fk_agency_code, primary_station_id;');
	dbms_output.put_line('SPOOL OFF');

END LOOP;
CLOSE c_Counties;

END;
/
SHOW ERRORS;